<?php

/* -----------------------------------------------------------------
 * 	$Id: cseo_rma.php 1002 2014-05-05 15:14:06Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
require('includes/application_top.php');
$coo_text_mgr = new LanguageTextManager('cseo_rma', $_SESSION['languages_id']);
$smarty = new Smarty;
$smarty->assign('txt', $coo_text_mgr->v_section_content_array['cseo_rma']);

require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'cseo_rma.inc.php');

require(DIR_WS_CLASSES . 'class.order.php');

$languages = xtc_get_languages();

$smarty_mail = new Smarty;
$smarty_mail->assign('language', $_SESSION['language']);
$smarty_mail->caching = false;
$smarty_mail->template_dir = DIR_FS_CATALOG . 'templates';
$smarty_mail->compile_dir = DIR_FS_CATALOG . 'templates_c';
$smarty_mail->config_dir = DIR_FS_CATALOG . 'lang';

$load_text = array();
$rma_templates_query = xtc_db_query("SELECT * FROM " . TABLE_RMA_TEMPLATES . " WHERE language_id = '" . (int) $_SESSION['languages_id'] . "'");
while ($templates = xtc_db_fetch_array($rma_templates_query)) {
    $load_text[] = array(
        'id' => $templates['rma_template_text'],
        'text' => $templates['rma_template_name']);
}

$change_rma = array();
$change_rma[] = array('id' => 0, 'text' => TABLE_FOOTER_ACTION_0);
$change_rma[] = array('id' => 1, 'text' => TABLE_FOOTER_ACTION_DELETE_ALL);

$rma_status_select = array();
$rma_status_select[] = array('id' => 0, 'text' => TABLE_HEADING_SELECT_ALL);

$rma_status = array();
$rma_status_array = array();
$rma_status_query = xtc_db_query("SELECT rma_status_id, rma_status_name FROM " . TABLE_RMA_STATUS . " WHERE language_id = '" . (int) $_SESSION['languages_id'] . "'");
while ($rma = xtc_db_fetch_array($rma_status_query)) {
    $rma_status[] = array(
        'id' => $rma['rma_status_id'],
        'text' => $rma['rma_status_name']);
    $rma_status_array[$rma['rma_status_id']] = $rma['rma_status_name'];

    $rma_status_select[] = array(
        'id' => $rma['rma_status_id'],
        'text' => $rma['rma_status_name']);
}

switch ($_GET['action']) {
    case 'new_reason':
        $lang = sizeof($languages);
        $count_reason = xtc_db_fetch_array(xtc_db_query("SELECT MAX(rma_reason_id) AS IDENTITY FROM " . TABLE_RMA_REASON));
        $next_reason_id = $count_reason['IDENTITY'];

        // aller erste antwort?
        if ($next_reason_id != 0 ? $next_reason_id +=1 : $next_reason_id = 1)
            ;

        for ($i = 0; $i < $lang; $i++) {
            $languages_id = $languages[$i]['id'];
            if ($_POST['rma_reason_name'][$languages_id] != '') {
                $reason_array = array(
                    'rma_reason_id' => $next_reason_id,
                    'language_id' => $languages_id,
                    'rma_reason_name' => xtc_db_prepare_input($_POST['rma_reason_name'][$languages_id]));

                xtc_db_perform(TABLE_RMA_REASON, $reason_array);
            }
        } // -- FOR
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));
        break;
    case 'change_reason_update':
        $lang = sizeof($languages);
        $ids = count($_POST['rma_reason_id']);
        $delete_ids = count($_POST['delete']);

        // DELETE
        if (isset($_POST['delete'])) {
            for ($b = 0; $b < $delete_ids; $b++) {
                $delete_array = $_POST['delete'][$b];
                xtc_db_query("DELETE FROM " . TABLE_RMA_REASON . " WHERE rma_reason_id = '" . $delete_array . "'");
            }
		// UPDATE
        } elseif (isset($_POST['rma_reason_id'])) {
            for ($b = 0; $b < $ids; $b++) {
                $reason_id = $_POST['rma_reason_id'][$b];
                for ($i = 0; $i < $lang; $i++) {
                    $languages_id = $languages[$i]['id'];

                    xtc_db_query("UPDATE " . TABLE_RMA_REASON . " SET
							rma_reason_name = '" . xtc_db_prepare_input($_POST['rma_reason_name'][$languages_id][$reason_id]) . "'
								WHERE rma_reason_id = '" . $reason_id . "'
								AND language_id = '" . $languages_id . "'");
                }
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));
        break;
    case 'new_status':
        $lang = sizeof($languages);
        $count_status = xtc_db_fetch_array(xtc_db_query("SELECT MAX(rma_status_id) AS IDENTITY FROM " . TABLE_RMA_STATUS));
        $next_status_id = $count_status['IDENTITY'];

        // aller erste antwort?
        if ($next_status_id != 0 ? $next_status_id +=1 : $next_status_id = 1)
            ;

        for ($i = 0; $i < $lang; $i++) {
            $languages_id = $languages[$i]['id'];

            if ($_POST['rma_status_name'][$languages_id] != '') {
                $status_array = array(
                    'rma_status_id' => $next_status_id,
                    'language_id' => $languages_id,
                    'rma_status_name' => xtc_db_prepare_input($_POST['rma_status_name'][$languages_id]));

                xtc_db_perform(TABLE_RMA_STATUS, $status_array);
            }
        } // -- FOR
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
        break;
    case 'change_status_update':
        $lang = sizeof($languages);
        $ids = count($_POST['rma_status_id']);
        $delete_ids = count($_POST['delete']);

        if (isset($_POST['delete'])) {
        // DELETE
            for ($b = 0; $b < $delete_ids; $b++) {
                $delete_array = $_POST['delete'][$b];
                xtc_db_query("DELETE FROM " . TABLE_RMA_STATUS . " WHERE rma_status_id = '" . $delete_array . "'");
            }
        } elseif (isset($_POST['rma_status_id'])) {
		// UPDATE
            for ($b = 0; $b < $ids; $b++) {
                $status_id = $_POST['rma_status_id'][$b];
                for ($i = 0; $i < $lang; $i++) {
                    $languages_id = $languages[$i]['id'];
                    xtc_db_query("UPDATE " . TABLE_RMA_STATUS . " SET
							rma_status_name = '" . xtc_db_prepare_input($_POST['rma_status_name'][$languages_id][$status_id]) . "'
								WHERE rma_status_id = '" . $status_id . "'
								AND language_id = '" . $languages_id . "'");
                }
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
        break;
    case 'new_template':
        $lang = sizeof($languages);
        $count_status = xtc_db_fetch_array(xtc_db_query("SELECT MAX(rma_template_id) AS IDENTITY FROM " . TABLE_RMA_TEMPLATES));
        $next_status_id = $count_status['IDENTITY'];

        // aller erste antwort?
        if ($next_status_id != 0 ? $next_status_id +=1 : $next_status_id = 1)
            ;

        for ($i = 0; $i < $lang; $i++) {
            $languages_id = $languages[$i]['id'];
            if ($_POST['rma_template_name'][$languages_id] != '') {
                $status_array = array(
                    'rma_template_id' => $next_status_id,
                    'language_id' => $languages_id,
                    'rma_template_name' => xtc_db_prepare_input($_POST['rma_template_name'][$languages_id]),
                    'rma_template_text' => xtc_db_prepare_input($_POST['rma_template_text'][$languages_id])
					
					);
                xtc_db_perform(TABLE_RMA_TEMPLATES, $status_array);
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
        break;
    case 'change_template_update':
        $lang = sizeof($languages);
        $ids = count($_POST['rma_template_id']);
        $delete_ids = count($_POST['delete']);
        if (isset($_POST['delete'])) {
        // DELETE
            for ($b = 0; $b < $delete_ids; $b++) {
                $delete_array = $_POST['delete'][$b];
                xtc_db_query("DELETE FROM " . TABLE_RMA_TEMPLATES . " WHERE rma_template_id = '" . $delete_array . "'");
            }
        } elseif (isset($_POST['rma_template_id'])) {
		// UPDATE
            for ($b = 0; $b < $ids; $b++) {
                $status_id = $_POST['rma_template_id'][$b];
                for ($i = 0; $i < $lang; $i++) {
                    $languages_id = $languages[$i]['id'];
                    xtc_db_query("UPDATE " . TABLE_RMA_TEMPLATES . " SET
							rma_template_name = '" . xtc_db_prepare_input($_POST['rma_template_name'][$languages_id][$status_id]) . "', 
							rma_template_text = '" . xtc_db_prepare_input($_POST['rma_template_text'][$languages_id][$status_id]) . "'
								WHERE rma_template_id = '" . $status_id . "'
								AND language_id = '" . $languages_id . "'");
                }
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
        break;
    case 'change': // Markierte löschen
        if ($_POST['rma_action'] == 1) {
            $anz = count($_POST['status']);
            for ($i = 0; $i < $anz; $i++) {
                xtc_db_query("DELETE FROM " . TABLE_RMA . " WHERE rma_id	= '" . $_POST['status'][$i] . "'");
                xtc_db_query("DELETE FROM " . TABLE_RMA_COMMENTS . " WHERE rma_id	= '" . $_POST['status'][$i] . "'");
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RMA, '', 'SSL'));
        break;
    case 'newrma_insert':
        // Manueller Eintrag
        $customers_id = xtc_db_prepare_input($_POST['customers_id']);
        $orders_id = xtc_db_prepare_input($_POST['orders_id']);
        $products_id = xtc_db_prepare_input($_POST['products_id']);
        $products_ean = xtc_db_prepare_input($_POST['products_ean']);
        $reason_id = xtc_db_prepare_input($_POST['reason_id']);
        $shipping_time = xtc_db_prepare_input($_POST['shipping_time']);
        $pickup = xtc_db_prepare_input($_POST['pickup']);
        $cost_estimate = xtc_db_prepare_input($_POST['cost_estimate']);
        $comments = xtc_db_prepare_input($_POST['comments']);

        $order = new order($orders_id);
        $date_now = date("Y-m-d H:i:s");

        $new_rma_array = array(
            'customers_id' => $customers_id,
            'orders_id' => $orders_id,
            'products_id' => $products_id,
            'products_ean' => $products_ean,
            'reason_id' => $reason_id,
            'description' => $_POST['description'],
            'rma_date' => $date_now,
            'pickup' => $pickup,
            'shipping_time' => $shipping_time,
            'rma_status_id' => (int) $_POST['status'],
            'cost_estimate' => $cost_estimate);

        xtc_db_perform(TABLE_RMA, $new_rma_array);

        // kommentare + status eintragen
        $comments_array = array(
            'rma_id' => (int) $_POST['rma_id'],
            'rma_status_id' => (int) $_POST['status'],
            'comments' => $comments,
            'edit_date' => $date_now);

        xtc_db_perform(TABLE_RMA_COMMENTS, $comments_array);

        // Email senden ??
        if (isset($_POST['status'])) {
            // Kundendaten holen
            $customers_query = xtc_db_query("SELECT
					customers_firstname,
					customers_lastname,
					customers_email_address
						FROM " . TABLE_CUSTOMERS . "
							WHERE customers_id = '" . $customers_id . "'");
            $customers = xtc_db_fetch_array($customers_query);

            // NAME BILDEN
            $customers_name = $customers['customers_firstname'] . ' ' . $customers['customers_lastname'];

            // Kommentare senden
            if (isset($_POST['comments_send'])) {
                $smarty_mail->assign('NOTIFY_COMMENTS', $comments);
            }
            // Mail senden
            $smarty_mail->assign('RMA_STATUS', $rma_status_array[$_POST['status']]);
            $smarty_mail->assign('NAME', $customers_name);

            if (isset($_POST['mail_send'])) {
                $html_mail = $smarty_mail->fetch(CURRENT_TEMPLATE . '/admin/mail/' . $order->info['language'] . '/change_rma_mail.html');
                $txt_mail = $smarty_mail->fetch(CURRENT_TEMPLATE . '/admin/mail/' . $order->info['language'] . '/change_rma_mail.txt');

                xtc_php_mail(EMAIL_BILLING_ADDRESS, EMAIL_BILLING_NAME, $customers['customers_email_address'], $customers_name, '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, '', '', EMAIL_RMA_SUBJECT, $html_mail, $txt_mail);
            }
        }

        xtc_redirect(xtc_href_link(FILENAME_RMA, '', 'SSL'));
        break;
    case 'update_rma':

        $comments = xtc_db_prepare_input($_POST['comments']);
        $order = new order($_POST['orders_id']);
        $date_now = date("Y-m-d H:i:s");

        if (isset($_POST['status'])) {
            // Kundendaten holen
            $customers_query = xtc_db_query("SELECT
					customers_firstname,
					customers_lastname,
					customers_email_address
						FROM " . TABLE_CUSTOMERS . "
							WHERE customers_id = '" . $_POST['customers_id'] . "'");
            $customers = xtc_db_fetch_array($customers_query);

            // NAME BILDEN
            $customers_name = $customers['customers_firstname'] . ' ' . $customers['customers_lastname'];

            // Neuer Eintrag, comments
            $comments_array = array(
                'rma_id' => (int) $_POST['rma_id'],
                'rma_status_id' => (int) $_POST['status'],
                'comments' => $comments,
                'edit_date' => $date_now);

            xtc_db_perform(TABLE_RMA_COMMENTS, $comments_array);

            // RMA tabelle aktualisieren, status
            xtc_db_query("UPDATE " . TABLE_RMA . " SET
								rma_status_id 	= '" . (int) $_POST['status'] . "'
								WHERE rma_id		= '" . (int) $_POST['rma_id'] . "'");

            // Kommentare senden
            if (isset($_POST['comments_send'])) {
                $smarty_mail->assign('NOTIFY_COMMENTS', $comments);
            }
            // Mail senden
            $smarty_mail->assign('RMA_STATUS', $rma_status_array[$_POST['status']]);
            $smarty_mail->assign('NAME', $customers_name);

            if (isset($_POST['mail_send'])) {
                $html_mail = $smarty_mail->fetch(CURRENT_TEMPLATE . '/admin/mail/' . $order->info['language'] . '/change_rma_mail.html');
                $txt_mail = $smarty_mail->fetch(CURRENT_TEMPLATE . '/admin/mail/' . $order->info['language'] . '/change_rma_mail.txt');

                xtc_php_mail(EMAIL_BILLING_ADDRESS, EMAIL_BILLING_NAME, $customers['customers_email_address'], $customers_name, '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, '', '', EMAIL_RMA_SUBJECT, $html_mail, $txt_mail);
            }
        }

        xtc_redirect(xtc_href_link(FILENAME_RMA, '', 'SSL'));
        break;
    case 'newrma': // RMA DATEN
        if ($_POST['keyword'] != '') {
            $search_product_query = xtc_db_query("SELECT p.products_id, pd.products_name FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd
					where p.products_id = pd.products_id
					AND pd.language_id = '" . $_SESSION['languages_id'] . "'
					AND pd.products_name LIKE '%" . $_POST['keyword'] . "%'
					OR p.products_model LIKE '%" . $_POST['keyword'] . "%'
						ORDER BY p.products_id ASC");
        } else {
            $search_product_query = xtc_db_query("SELECT p.products_id, pd.products_name FROM " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd
					where p.products_id = '" . (int) $_POST['products_id'] . "'
					AND p.products_id = pd.products_id
					AND pd.language_id = '" . $_SESSION['languages_id'] . "'");
        }

        $products_ids = array();
        while ($search_product = xtc_db_fetch_array($search_product_query)) {
            $products_ids[] = array(
                'id' => $search_product['products_id'],
                'text' => $search_product['products_name'] . ' - ID.' . $search_product['products_id']);
        }


        // next rma id
        $next_rma_id_query = xtc_db_query("SELECT MAX(rma_id+1) AS next_id FROM " . TABLE_RMA);
        $next_rma_id = xtc_db_fetch_array($next_rma_id_query);

        // orders
        $order_ids = array();
        $orders_query = xtc_db_query("select orders_id, DATE_FORMAT(date_purchased , '%d.%m.%Y') AS DATE from " . TABLE_ORDERS . " ORDER BY orders_id DESC");
        while ($orders = xtc_db_fetch_array($orders_query)) {
            $order_ids[] = array(
                'id' => $orders['orders_id'],
                'text' => $orders['orders_id'] . ' - ' . $orders['DATE']);
        }

        // customers
        if ($_POST['customer_keyword'] != '') {
            $customers_query = xtc_db_query("select customers_id, customers_cid, customers_gender, customers_firstname, customers_lastname
					from " . TABLE_CUSTOMERS . "
					WHERE customers_lastname LIKE '%" . $_POST['customer_keyword'] . "%'
						OR customers_firstname LIKE '%" . $_POST['customer_keyword'] . "%'
						OR customers_cid LIKE '%" . $_POST['customer_keyword'] . "%'
						ORDER BY customers_id ASC");
        } else {
            $customers_query = xtc_db_query("select customers_id, customers_cid, customers_gender, customers_firstname, customers_lastname
					from " . TABLE_CUSTOMERS . "
					WHERE customers_id = '" . $_POST['customers_id'] . "'");
        }

        $customers_ids = array();
        while ($customers = xtc_db_fetch_array($customers_query)) {
            $customers_ids[] = array(
                'id' => $customers['customers_id'],
                'text' => $customers['customers_lastname'] . ' ' . $customers['customers_firstname'] . ', ' . PULL_DOWN_CUSTOMER_NO . '' . $customers['customers_cid'] . ', (ID.' . $customers['customers_id'] . ')');
        }

        break;
    case 'showrma': // RMA DATEN
        $show_orders = xtc_db_fetch_array(xtc_db_query("SELECT * FROM rma LEFT JOIN customers ON(rma.customers_id = customers.customers_id) WHERE rma.rma_id = '" . (int) $_GET['oID'] . "' LIMIT 0 , 30;"));
        break;

    default: // alle anzeigen
        // sortierung
        if ((int) $_GET['sort'] == 0) {
            $sorting = '';
        } elseif ((int) $_GET['sort'] >= 1) {
            $sorting = 'AND rma.rma_status_id = ' . (int) $_GET['sort'];
        }

        $orders_all_query = xtc_db_query("SELECT
			rma.rma_id as rma_id,
			rma.pickup as pickup,
			rma.customers_id as customers_id,
			rma.shipping_time as shipping_time,
			rma.orders_id as orders_id,
			rma.rma_date as rma_date,
			rma.rma_status_id as rma_status_id,
			c.customers_firstname as customers_firstname,
			c.customers_lastname as customers_lastname,
			rma.products_id,
			rma.description as description
				FROM " . TABLE_RMA . " rma,
					" . TABLE_CUSTOMERS . " c
		WHERE rma.customers_id = c.customers_id
		" . $sorting . "
		ORDER BY rma.rma_id DESC;");
        $count_orders = xtc_db_num_rows($orders_all_query);
}
require_once(DIR_WS_INCLUDES . 'header.php');

if ($_GET['action'] == 'change_reason') {
    $count_languages = sizeof($languages);
    $smarty->assign('CHANGE_REASON', 'true');
    $smarty->assign('FORM_RMA', xtc_draw_form('rma_reason', FILENAME_RMA, 'action=change_reason_update', 'post', ''));
    $smarty->assign('FILENAME_RMA', xtc_href_link(FILENAME_RMA));
    $smarty->assign('FILENAME_RMA_CHANGE', xtc_href_link(FILENAME_RMA, 'action=change_status'));
	$smarty->assign('FILENAME_RMA_CHANGE_TEMPLATE', xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
    $reason_id_array = array();
    $count_reason_items_query = xtc_db_query("SELECT DISTINCT rma_reason_id FROM " . TABLE_RMA_REASON);
    while ($count_reason_items = xtc_db_fetch_array($count_reason_items_query)) {
        $reason_id_array[] = array('id' => $count_reason_items['rma_reason_id']);
    }
    $count_reason_array = count($reason_id_array);
    for ($a = 0; $a < $count_reason_array; $a++) {
        for ($i = 0; $i < $count_languages; $i++) {
            $change_reason = xtc_db_fetch_array(xtc_db_query("SELECT rma_reason_id, language_id, rma_reason_name FROM " . TABLE_RMA_REASON . " WHERE language_id = '" . $languages[$i]['id'] . "' AND rma_reason_id = '" . $reason_id_array[$a]['id'] . "';"));
            $delete_rma = '';
            if ($change_reason['language_id'] == $count_languages) {
                $delete_rma = xtc_draw_selection_field('delete[]', 'checkbox', $reason_id_array[$a]['id']) . TEXT_STATUS_DELETE;
            }
            $rmaedit[$a][$i] = array(
                'hidden' => xtc_draw_hidden_field('rma_reason_id[]', $change_reason['rma_reason_id']),
                'langname' => $languages[$i]['code'],
                'rma_reason_name' => xtc_draw_input_field('rma_reason_name[' . $languages[$i]['id'] . '][' . $reason_id_array[$a]['id'] . ']', $change_reason['rma_reason_name'], 'size="50"'),
                'delete_rma' => $delete_rma
            );
        }
    }

    $smarty->assign('RMA_EDIT', $rmaedit);
    $smarty->assign('RMA_SUBMIT', xtc_draw_input_field('submit', TEXT_UPDATE, 'class="btn btn-success"', false, 'submit'));
    $smarty->assign('FORM_END', '</form>');
    $smarty->assign('FORM_RMA_REASON', xtc_draw_form('rma_reason', FILENAME_RMA, 'action=new_reason', 'post', ''));
    $smarty->assign('RMA_SAVE', xtc_draw_input_field('submit', TEXT_SAVE, 'class="btn btn-success"', false, 'submit'));

    for ($i = 0; $i < $count_languages; $i ++) {
        $rmanew[$i] = array(
            'langname' => $languages[$i]['code'],
            'rma_new_reason_name' => xtc_draw_input_field('rma_reason_name[' . $languages[$i]['id'] . ']', '', 'size="50"')
        );
    }
    $smarty->assign('RMA_NEW', $rmanew);
} elseif ($_GET['action'] == 'change_status') {
    // STATUS BEARBEITEN
    $count_languages = sizeof($languages);
    $smarty->assign('EDIT_STATUS', 'true');
    $smarty->assign('FORM_RMA_STATUS', xtc_draw_form('rma_status', FILENAME_RMA, 'action=change_status_update', 'post', ''));
    $smarty->assign('FILENAME_RMA', xtc_href_link(FILENAME_RMA));
    $smarty->assign('FILENAME_RMA_CHANGE', xtc_href_link(FILENAME_RMA, 'action=change_reason'));
	$smarty->assign('FILENAME_RMA_CHANGE_TEMPLATE', xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));

    $count_languages = sizeof($languages);
    $status_id_array = array();

    $count_status_items_query = xtc_db_query("SELECT DISTINCT rma_status_id FROM " . TABLE_RMA_STATUS);
    while ($count_status_items = xtc_db_fetch_array($count_status_items_query)) {
        $status_id_array[] = array('id' => $count_status_items['rma_status_id']);
    }
    $count_status_array = count($status_id_array);
    for ($a = 0; $a < $count_status_array; $a++) {
        for ($i = 0; $i < $count_languages; $i++) {
            $change_status = xtc_db_fetch_array(xtc_db_query("SELECT rma_status_id, language_id, rma_status_name FROM " . TABLE_RMA_STATUS . " WHERE language_id = '" . $languages[$i]['id'] . "' AND rma_status_id = '" . $status_id_array[$a]['id'] . "';"));
            $delete_rma = '';
            if ($change_status['language_id'] == $count_languages) {
                $delete_rma = xtc_draw_selection_field('delete[]', 'checkbox', $status_id_array[$a]['id']) . TEXT_STATUS_DELETE;
            }


            $rmastatus[$a][$i] = array(
                'hidden' => xtc_draw_hidden_field('rma_status_id[]', $change_status['rma_status_id']),
                'langname' => $languages[$i]['code'],
                'rma_reason_name' => xtc_draw_input_field('rma_status_name[' . $languages[$i]['id'] . '][' . $status_id_array[$a]['id'] . ']', $change_status['rma_status_name'], 'size="50"'),
                'delete_rma' => $delete_rma
            );
        }
    }
    $smarty->assign('RMA_STATUS_EDIT', $rmastatus);
    $smarty->assign('RMA_STATUS_UPDATE', xtc_draw_input_field('submit', TEXT_UPDATE, 'class="btn btn-success"', false, 'submit'));
    $smarty->assign('FORM_END', '</form>');
    $smarty->assign('FORM_RMA_STATUS_NEW', xtc_draw_form('rma_status', FILENAME_RMA, 'action=new_status', 'post', ''));

    for ($i = 0; $i < $count_languages; $i ++) {
        $rmastatusnew[$i] = array(
            'langname' => $languages[$i]['code'],
            'rma_new_reason_name' => xtc_draw_input_field('rma_status_name[' . $languages[$i]['id'] . ']', '', 'size="50"')
        );
        $smarty->assign('RMA_STATUS_NEW', $rmastatusnew);
        $smarty->assign('RMA_STATUS_SAVE', xtc_draw_input_field('submit', TEXT_SAVE, 'class="btn btn-success"', false, 'submit'));
    }
} elseif ($_GET['action'] == 'newrma') {
    // NEUE RMA DATEN
    $smarty->assign('RMA_NEW', 'true');
    if (sizeof($products_ids) == 0) {
        $smarty->assign('FORM_NEW_RMA', xtc_draw_form('product_search', FILENAME_RMA, 'action=newrma', 'post', ''));
    } elseif (sizeof($customers_ids) == 0) {
        $smarty->assign('FORM_NEW_RMA', xtc_draw_form('customer_search', FILENAME_RMA, 'action=newrma', 'post', ''));
    } else {
        $smarty->assign('FORM_NEW_RMA', xtc_draw_form('edit_rma', FILENAME_RMA, 'action=newrma_insert', 'post', ''));
    }
    $smarty->assign('FILENAME_RMA', xtc_href_link(FILENAME_RMA, '', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_STATUS', xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
	$smarty->assign('FILENAME_RMA_CHANGE_TEMPLATE', xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_REASON', xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));
    $smarty->assign('RMA_OIDPULL', xtc_draw_pull_down_menu('orders_id', $order_ids, $_GET['order'], ''));
    $smarty->assign('RMA_OID', xtc_draw_input_field('rma_id', $next_rma_id['next_id'], 'size="5"'));
    $smarty->assign('RMA_PICKUP', xtc_draw_selection_field('pickup', 'checkbox', '1'));
    $smarty->assign('RMA_DATE', xtc_datetime_short(date("Y.m.d H:i:s")));
    $smarty->assign('RMA_SHIPPING_TIME', xtc_draw_input_field('shipping_time', $_GET['shipping_time'], 'size="20"'));
    $smarty->assign('RMA_TIME', xtc_datetime_short($show_orders['rma_date_edit']));
    $smarty->assign('RMA_REASON_ID', xtc_draw_pull_down_menu('reason_id', sb_get_reasons(), $_GET['reason_id'], ''));
    if (sizeof($products_ids) == 0) {
        $smarty->assign('RMA_PRODUCT', xtc_draw_input_field('keyword', '', 'size="25"'));
        $smarty->assign('RMA_PRODUCT_SEARCH', xtc_draw_input_field('submit', BUTTON_RMA_SEARCH, 'class="btn btn-success"', false, 'submit'));
    } else {
        $smarty->assign('RMA_PRODUCT', xtc_draw_pull_down_menu('products_id', $products_ids, $_GET['product'], ''));
    }
    $smarty->assign('RMA_PRODUCTS_EAN', xtc_draw_input_field('products_ean', $_GET['ean'], 'size="20"'));
    if (sizeof($customers_ids) == 0) {
        $smarty->assign('RMA_CUSTOMER_KEYWORD', xtc_draw_input_field('customer_keyword', '', 'size="25"'));
        $smarty->assign('RMA_CUSTOMER_KEYWORD_SUBMIT', xtc_draw_input_field('submit', BUTTON_RMA_SEARCH, 'class="btn btn-success"', false, 'submit'));
    } else {
        $smarty->assign('RMA_CUSTOMER_KEYWORD', xtc_draw_pull_down_menu('customers_id', $customers_ids, (int) $_GET['customer'], ''));
    }
    $smarty->assign('RMA_COST_ESTIMATE', xtc_draw_selection_field('cost_estimate', 'checkbox', '1'));
    $smarty->assign('RMA_DESC', xtc_draw_textarea_field('description', 'soft', '80', '6', '', ''));
    if (sizeof($products_ids) == 0) {
        $smarty->assign('FORM_BRAKE', '</form>');
    } elseif (sizeof($customers_ids) == 0) {
        $smarty->assign('FORM_BRAKE', '</form>');
    }
    $smarty->assign('RMA_STATUS', xtc_draw_pull_down_menu('status', $rma_status, '', ''));
    $smarty->assign('RMA_STATUS_TEXT', xtc_draw_pull_down_menu('text', $load_text, '', ''));
    $smarty->assign('RMA_STATUS_BUTTON_GO', xtc_draw_input_field('button', BUTTON_RMA_SEARCH, 'class="btn btn-success" onclick="this.form.comments.value = this.form.text.value"', false, 'button'));
    $smarty->assign('RMA_COMMENTS', xtc_draw_textarea_field('comments', 'soft', '70', '6', ''));
    $smarty->assign('RMA_COMMENTS_SEND', xtc_draw_selection_field('comments_send', 'checkbox', '1'));
    $smarty->assign('RMA_MAIL_SEND', xtc_draw_selection_field('mail_send', 'checkbox', '1'));
    $smarty->assign('RMA_STATUS_SUBMIT', xtc_draw_input_field('submit', TEXT_UPDATE_SAVE, 'class="btn btn-success" onclick="return confirm(\'' . UPDATE_ENTRY . '\')"', false, 'submit'));
} elseif ($_GET['action'] == 'showrma') {
    // RMA DATEN ANZEIGEN
    $smarty->assign('RMA_SHOWRMA', 'true');
    $smarty->assign('FILENAME_RMA', xtc_href_link(FILENAME_RMA, '', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE', xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_REASON', xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));
	$smarty->assign('FILENAME_RMA_CHANGE_TEMPLATE', xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
    $smarty->assign('RMA_ORDER', '<a href="' . xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $show_orders['orders_id'] . '&action=edit', 'SSL') . '">' . $show_orders['orders_id'] . '</a> / ' . $show_orders['rma_id']);
    if ($_GET['show'] == 'statistic') {
        $smarty->assign('RMA_SHOW_STATISTIC', '<a href="' . xtc_href_link(FILENAME_RMA, 'oID=' . $show_orders['rma_id'] . '&action=showrma', 'SSL') . '">' . RMA_STATISTIC_NO_SHOW . '</a>');
    } else {
        $smarty->assign('RMA_SHOW_STATISTIC', '<a href="' . xtc_href_link(FILENAME_RMA, 'oID=' . $show_orders['rma_id'] . '&action=showrma&show=statistic', 'SSL') . '">' . RMA_STATISTIC_SHOW . '</a>');
    }
    $smarty->assign('RMA_PICKUP', ($show_orders['pickup'] == 1 ? TEXT_PICKUP_YES : '-'));
    $smarty->assign('RMA_DATE', xtc_datetime_short($show_orders['rma_date']));
    $smarty->assign('RMA_SHIPPING_TIME', $show_orders['shipping_time']);
    $smarty->assign('RMA_TIME', xtc_datetime_short($show_orders['rma_date_edit']));
    $smarty->assign('RMA_REASON_ID', sb_get_reason($show_orders['reason_id']));
    $product_name = xtc_db_fetch_array(xtc_db_query(" SELECT products_name FROM orders_products WHERE products_id = '" . $show_orders['products_id'] . "' LIMIT 1"));
    $smarty->assign('RMA_PRODUCT', $product_name['products_name']);
    $smarty->assign('RMA_PRODUCTS_EAN', ($show_orders['products_ean'] ? $show_orders['products_ean'] : '-'));
    $smarty->assign('RMA_CUSTOMER_KEYWORD', '<a class="content_gift_link" href="' . xtc_href_link(FILENAME_CUSTOMERS, xtc_get_all_get_params(array('oID', 'action')) . 'cID=' . $show_orders['customers_id'] . '&action=edit', 'SSL') . '">' . $show_orders['customers_firstname'] . ' ' . $show_orders['customers_lastname'] . '</a>');
    $smarty->assign('RMA_COST_ESTIMATE', ($show_orders['cost_estimate'] == 1 ? TEXT_PICKUP_YES : '-'));
    $smarty->assign('RMA_DESCRIPTION', $show_orders['description']);

    if ($_GET['show'] == 'statistic') {
        $smarty->assign('RMA_SHOW_STATISTIC', 'true');
        $statistic_query = xtc_db_query("SELECT rma_comments_id, rma_status_id, comments, edit_date FROM " . TABLE_RMA_COMMENTS . " WHERE rma_id = '" . $show_orders['rma_id'] . "' ORDER BY rma_comments_id DESC");
        $i = 0;
        while ($statistic = xtc_db_fetch_array($statistic_query)) {
            $rmastatistic[$i] = array(
                'edit_date' => xtc_datetime_short($statistic['edit_date']),
                'comments' => $statistic['comments'],
                'rma_status_id' => sb_get_status($statistic['rma_status_id'])
            );
            $i++;
        }
        $smarty->assign('RMA_STATISTIC', $rmastatistic);
    } else {
        $smarty->assign('RMA_EDIT_RMA_FORM', xtc_draw_form('edit_rma', FILENAME_RMA, 'action=update_rma', 'post', ''));
        $smarty->assign('RMA_EDIT_RMA_HIDDEN', xtc_draw_hidden_field('customers_id', $show_orders['customers_id'])
                . xtc_draw_hidden_field('orders_id', $show_orders['orders_id'])
                . xtc_draw_hidden_field('rma_id', $show_orders['rma_id'])
        );
        $smarty->assign('RMA_EDIT_RMA_STATUS', xtc_draw_pull_down_menu('status', $rma_status, $show_orders['rma_status_id'], ''));
        $smarty->assign('RMA_EDIT_RMA_TEXT', xtc_draw_pull_down_menu('text', $load_text, '', ''));
        $smarty->assign('RMA_STATUS_BUTTON_GO', xtc_draw_input_field('button', BUTTON_RMA_SEARCH, 'class="btn btn-success" onclick="this.form.comments.value = this.form.text.value"', false, 'button'));
        $smarty->assign('RMA_STATUS_COMMENTS', xtc_draw_textarea_field('comments', 'soft', '70', '6', ''));
        $smarty->assign('RMA_STATUS_COMMENTS_SEND', xtc_draw_selection_field('comments_send', 'checkbox', '1'));
        $smarty->assign('RMA_STATUS_COMMENTS_MAIL_SEND', xtc_draw_selection_field('mail_send', 'checkbox', '1'));
        $smarty->assign('RMA_STATUS_COMMENTS_SUBMIT', xtc_draw_input_field('submit', RMA_UPDATE, 'class="btn btn-success" onclick="return confirm(\'' . UPDATE_ENTRY . '\')"', false, 'submit'));
        $smarty->assign('FORM_END', '</form>');
    }
} elseif ($_GET['action'] == 'change_text') {
    // TEXTE BEARBEITEN
    $count_languages = sizeof($languages);
    $smarty->assign('EDIT_TEXT', 'true');
    $smarty->assign('FORM_RMA_TEXT', xtc_draw_form('rma_template', FILENAME_RMA, 'action=change_template_update', 'post', ''));
    $smarty->assign('FILENAME_RMA', xtc_href_link(FILENAME_RMA));
    $smarty->assign('FILENAME_RMA_CHANGE_STATUS', xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_REASON', xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));

    $count_languages = sizeof($languages);
    $status_id_array = array();

    $count_status_items_query = xtc_db_query("SELECT DISTINCT rma_template_id FROM " . TABLE_RMA_TEMPLATES);
    while ($count_status_items = xtc_db_fetch_array($count_status_items_query)) {
        $status_id_array[] = array('id' => $count_status_items['rma_template_id']);
    }
	
    $count_status_array = count($status_id_array);
    for ($a = 0; $a < $count_status_array; $a++) {
        for ($i = 0; $i < $count_languages; $i++) {
            $change_status = xtc_db_fetch_array(xtc_db_query("SELECT * FROM " . TABLE_RMA_TEMPLATES . " WHERE language_id = '" . $languages[$i]['id'] . "' AND rma_template_id = '" . $status_id_array[$a]['id'] . "';"));
            $delete_rma = '';
            if ($change_status['language_id'] == $count_languages) {
                $delete_rma = xtc_draw_selection_field('delete[]', 'checkbox', $status_id_array[$a]['id']) . TEXT_STATUS_DELETE;
            }

            $rmastatus[$a][$i] = array(
                'hidden' => xtc_draw_hidden_field('rma_template_id[]', $change_status['rma_template_id']),
                'langname' => $languages[$i]['code'],
                'rma_template_name' => xtc_draw_input_field('rma_template_name[' . $languages[$i]['id'] . '][' . $status_id_array[$a]['id'] . ']', $change_status['rma_template_name'], 'size="50"'),
                // 'rma_template_text' => xtc_draw_input_field('rma_template_text[' . $languages[$i]['id'] . '][' . $status_id_array[$a]['id'] . ']', $change_status['rma_template_text'], 'size="50"'),
                'rma_template_text' => xtc_draw_textarea_field('rma_template_text[' . $languages[$i]['id'] . '][' . $status_id_array[$a]['id'] . ']', 'soft', '70', '6', $change_status['rma_template_text']),
                'delete_rma' => $delete_rma
            );
        }
    }
    $smarty->assign('RMA_STATUS_EDIT', $rmastatus);
    $smarty->assign('RMA_STATUS_UPDATE', xtc_draw_input_field('submit', TEXT_UPDATE, 'class="btn btn-success"', false, 'submit'));
    $smarty->assign('FORM_END', '</form>');
    $smarty->assign('FORM_RMA_STATUS_NEW', xtc_draw_form('rma_status', FILENAME_RMA, 'action=new_template', 'post', ''));

    for ($i = 0; $i < $count_languages; $i ++) {
        $rmastatusnew[$i] = array(
            'langname' => $languages[$i]['code'],
            'rma_new_template_name' => xtc_draw_input_field('rma_template_name[' . $languages[$i]['id'] . ']', '', 'size="50"'),
            'rma_new_template_text' => xtc_draw_textarea_field('rma_template_text[' . $languages[$i]['id'] . ']', 'soft', '70', '6', '')
        );
        $smarty->assign('RMA_STATUS_NEW', $rmastatusnew);
        $smarty->assign('RMA_STATUS_SAVE', xtc_draw_input_field('submit', TEXT_SAVE, 'class="btn btn-success"', false, 'submit'));
    }
} else {
    // ÜBERSICHT ANZEIGEN
    $smarty->assign('RMA_OVEVIEW', 'true');
    $smarty->assign('FILENAME_RMA_NEW', xtc_href_link(FILENAME_RMA, 'action=newrma', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE', xtc_href_link(FILENAME_RMA, 'action=change_status', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_TEMPLATE', xtc_href_link(FILENAME_RMA, 'action=change_text', 'SSL'));
    $smarty->assign('FILENAME_RMA_CHANGE_REASON', xtc_href_link(FILENAME_RMA, 'action=change_reason', 'SSL'));
    $smarty->assign('RMA_SORT_FORM', xtc_draw_form('sort_rma', FILENAME_RMA, 'action=sort', '', 'get'));
    $smarty->assign('RMA_SORT_PULL', xtc_draw_pull_down_menu('sort', $rma_status_select, '', 'onchange="this.form.submit();"'));
    $smarty->assign('FORM_END', '</form>');
    $smarty->assign('RMA_RMA_ACTION', xtc_draw_form('rma_action', FILENAME_RMA, 'action=change', 'post', ''));

    if ($count_orders > 0) {
        $i = 0;
        while ($show_orders = xtc_db_fetch_array($orders_all_query)) {
            $rma_status = xtc_db_fetch_array(xtc_db_query("SELECT rma_status_id, rma_status_name FROM " . TABLE_RMA_STATUS . " where language_id = '" . (int) $_SESSION['languages_id'] . "' AND rma_status_id='" . $show_orders['rma_status_id'] . "';"));
            $product_name = xtc_db_fetch_array(xtc_db_query(" SELECT products_name FROM orders_products WHERE products_id = '" . $show_orders['products_id'] . "' LIMIT 1"));
            $rmaoverview[$i] = array(
                'status' => xtc_draw_selection_field('status[]', 'checkbox', $show_orders['rma_id']),
                'link_rma' => '<a href="' . xtc_href_link(FILENAME_RMA, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $show_orders['rma_id'] . '&action=showrma', 'SSL') . '">' . $show_orders['rma_id'] . '</a>',
                'link_order' => '<a class="content_gift_link" href="' . xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('oID', 'action')) . 'oID=' . $show_orders['orders_id'] . '&action=edit', 'SSL') . '">' . $show_orders['orders_id'] . '</a>',
                'product_name' => $product_name['products_name'],
                'link_customer' => '<a href="' . xtc_href_link(FILENAME_CUSTOMERS, xtc_get_all_get_params(array('oID', 'action')) . 'cID=' . $show_orders['customers_id'] . '&action=edit', 'SSL') . '">' . $show_orders['customers_firstname'] . ' ' . $show_orders['customers_lastname'] . '</a>',
                'rma_date' => xtc_datetime_short($show_orders['rma_date']),
                'rma_date_edit' => xtc_datetime_short($show_orders['rma_date_edit']),
                'rma_status_name' => $rma_status['rma_status_name'],
            );

            $i++;
        }
        $smarty->assign('RMA_OVERVIEW', $rmaoverview);
        $smarty->assign('RMA_ACTION', xtc_draw_pull_down_menu('rma_action', $change_rma, '', ''));
        // $smarty->assign('RMA_ACTION_SUBMIT', '<input type="submit" value="GO!" onClick="return confirm(\'' . UPDATE_ENTRY . '\')">');
		$smarty->assign('RMA_ACTION_SUBMIT', xtc_draw_input_field('submit', 'Go', 'class="btn btn-success" onclick="return confirm(\'' . UPDATE_ENTRY . '\')"', false, 'submit'));
    } else {
        $smarty->assign('RMA_NO_ORDERS', 'true');
    }
}
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('logo_path', HTTP_SERVER . DIR_WS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/img/');
$smarty->caching = false;
$smarty->template_dir = DIR_FS_CATALOG . 'admin/templates/';
$smarty->compile_dir = DIR_FS_CATALOG . 'admin/templates_c';
$smarty->display(CURRENT_ADMIN_TEMPLATE . '/cseo_rma.html');


require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
